IF OBJECT_ID('EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL') IS NULL 
begin
CREATE TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_CTR] [int] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[DT_ULT_ALT] [datetime] NULL,
 CONSTRAINT [PK_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL] UNIQUE NONCLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PARAM_COMPRAS_GRUPO] FOREIGN KEY([CD_CTR])
REFERENCES [dbo].[EST_PARAM_COMPRAS_GRUPO] ([CD_CTR])

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL] CHECK CONSTRAINT [FK_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PARAM_COMPRAS_GRUPO]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_PRC_FILIAL] FOREIGN KEY([CD_EMP], [CD_FILIAL])
REFERENCES [dbo].[PRC_FILIAL] ([CD_EMP], [CD_FILIAL])

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL] CHECK CONSTRAINT [FK_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_PRC_FILIAL]
end